﻿/*	VERSION:	1.1
1.1		


USAGE: 	
	#include "functions/dragSelfList.as"
	dragSelfList( list );
	
	react.to("checkImport").from(list).then = function ( evt ){
		if( !evt.data )		evt.callback( false);		// don't like data  =>  reject  (no response => accept)
	}// checkImport()
	
	
EVENTS: 
	swap
		data:	removedItem
		from:	fromIndex
		to:		toIndex
	checkImport
		data
		from
		to
		callback( response_bool )		// false = reject
	
	
DESCRIPTION: 
	Allows list items to be rearranged within the same list via drag-and-drop.
	
	
NOTES: 
	Regular drag-and-drop events will detect these "import" and "export" events.
	... checking for expected data contents will prevent confusion.
	
*/
function dragSelfList( self ){
	
	if( !self )		return;
	
	
	
	// __________________________________________________
	#include "dragDrop.as"
	#include "getListMouseIndex.as"
	
	
	// "react" event system
	#include "eventSystem3.as"
	if(!self.addListener)		AsBroadcaster.initialize( self );
	if(!react)								var react = make_react( self );		// param is optional
	
	
	DRAGDROP.enable( self, "both" );		// import export both
	// figure out the currently hovered index
	var getListMouseIndex = make_getListMouseIndex( self );
	var fromIndex;
	
	
	
	// send drag
	react.to( "export" ).from( self ).then = function( evt ){
		var hoverIndex = getListMouseIndex();
		if( hoverIndex === undefined )		return;
		fromIndex = hoverIndex;
		
		if( evt.data )						return;		// ignore if:  Export data has already been created
		
		// create export data
		evt.data = self.getItemAt( hoverIndex );
	}// export()
	
	
	
	// recieve drop
	react.to( "import" ).from( self ).then = function( evt ){
		if( fromIndex === undefined )		return;
		var hoverIndex = getListMouseIndex();
		if( hoverIndex === undefined )		return;
		
		// do stuff with imported evt.data
		var data = evt.data;
		var toIndex = getListMouseIndex();
		if( fromIndex === toIndex )		return;		// ignore droopping an item onto itself  (a swap would be redundant)
		
		// request external check before accepting import  (no response = accept,  false = reject)
		var acceptImport = true;
		var check_evt = {};
		for(var nam in evt)		check_evt[ nam ] = evt[ nam ];
		check_evt.callback = function( response ){
			acceptImport = Boolean( response );
		}// callback()
		sendEvent( "checkImport", check_evt, self );
		if( acceptImport === false )		return;
		
		// remove item
		var removedItem = self.removeItemAt( fromIndex );
		
		// add item
		self.addItemAt( toIndex, removedItem );
		
		sendEvent("swap", {
			data: removedItem, 
			from: fromIndex, 
			to: toIndex
		}, self);
		
		// reset fromIndex
		fromIndex = undefined;
		
		// announce that the value was accepted and the drop succeeded
		evt.dataAccepted();		// this fires "exportAccepted" within the originating object
	}// import()
	
	
}// dragSelfList()